<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Expense;
use App\Account;
use App\CashRegister;
use App\ExpenseCategory;
use App\Warehouse;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Auth;
use DB;

class ExpenseController extends Controller
{
    public function index(Request $request)
    {
        $role = Role::find(Auth::user()->role_id);
        if($role->hasPermissionTo('expenses-index')){
            $permissions = Role::findByName($role->name)->permissions;
            foreach ($permissions as $permission)
                $all_permission[] = $permission->name;
            if(empty($all_permission))
                $all_permission[] = 'dummy text';
            $lims_account_list = Account::where('is_active', true)->get();

            if($request->start_date) {
                $start_date = $request->start_date;
                $end_date = $request->end_date;
            }
            else {
                $start_date = date('Y-m-01', strtotime('-1 year', strtotime(date('Y-m-d'))));
                $end_date = date("Y-m-d");
            }

            if(Auth::user()->role_id > 2 && config('staff_access') == 'own')
                $lims_expense_all = Expense::where('user_id', Auth::id())->whereDate('created_at', '>=', $start_date)->whereDate('created_at', '<=', $end_date)->orderBy('id', 'desc')->get();
            else
                $lims_expense_all = Expense::whereDate('created_at', '>=', $start_date)->whereDate('created_at', '<=', $end_date)->orderBy('id', 'desc')->get();
            return view('expense.index', compact('lims_account_list', 'lims_expense_all', 'all_permission', 'start_date', 'end_date'));
        }
        else
            return redirect()->back()->with('not_permitted', 'Sorry! You are not allowed to access this module');
    }

    public function create()
    {
        $lims_expense_category_list = ExpenseCategory::where('is_active', true)->get();
        $lims_warehouse_list = Warehouse::select('id', 'name')->where('is_active', true)->get();
        $lims_account_list = Account::select('id', 'name')->where('is_active', true)->get();
        return view('expense.create', compact('lims_expense_category_list', 'lims_warehouse_list', 'lims_account_list'));
    }

    public function store(Request $request)
    {
        $data = $request->all();
        //return $data;
        foreach ($data['expense_category_id'] as $key => $expense_category_id) {
            if(isset($data['created_at'][$key]))
                $input['created_at'] = date("Y-m-d H:i:s", strtotime($data['created_at'][$key]));
            else
                $input['created_at'] = date("Y-m-d H:i:s");

            $input['reference_no'] = 'er-' . date("Ymd") . '-'. date("his");
            $input['user_id'] = Auth::id();
            $input['expense_category_id'] = $expense_category_id;
            $input['warehouse_id'] = $data['warehouse_id'][$key];
            $input['account_id'] = $data['account_id'][$key];
            $input['amount'] = $data['amount'][$key];
            $input['note'] = $data['note'][$key];
            /*$cash_register_data = CashRegister::where([
                ['user_id', $data['user_id']],
                ['warehouse_id', $data['warehouse_id']],
                ['status', true]
            ])->first();
            if($cash_register_data)
                $data['cash_register_id'] = $cash_register_data->id;*/

            $expense_data = Expense::create($input);
        }
        return redirect('expenses')->with('message', 'Data inserted successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $role = Role::firstOrCreate(['id' => Auth::user()->role_id]);
        if ($role->hasPermissionTo('expenses-edit')) {
            $lims_expense_data = Expense::find($id);
            $lims_expense_data->date = date('d-m-Y', strtotime($lims_expense_data->created_at->toDateString()));
            return $lims_expense_data;
        }
        else
            return redirect()->back()->with('not_permitted', 'Sorry! You are not allowed to access this module');
    }

    public function update(Request $request, $id)
    {
        $data = $request->all();
        $lims_expense_data = Expense::find($data['expense_id']);
        $data['created_at'] = date("Y-m-d H:i:s", strtotime($data['created_at']));
        $lims_expense_data->update($data);
        return redirect('expenses')->with('message', 'Data updated successfully');
    }

    public function deleteBySelection(Request $request)
    {
        $expense_id = $request['expenseIdArray'];
        foreach ($expense_id as $id) {
            $lims_expense_data = Expense::find($id);
            $lims_expense_data->delete();
        }
        return 'Expense deleted successfully!';
    }

    public function destroy($id)
    {
        $lims_expense_data = Expense::find($id);
        $lims_expense_data->delete();
        return redirect('expenses')->with('not_permitted', 'Data deleted successfully');
    }
}
