@extends('layout.main') @section('content')
@if(session()->has('not_permitted'))
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
@endif
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>{{trans('file.Add Expense')}}</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => 'expenses.store', 'method' => 'post', 'files' => true, 'id' => 'expense-form']) !!}
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-3">
                                        <label>{{trans('file.Select Expense Category')}}</label>
                                        <div class="search-box input-group">
                                            <button class="btn btn-secondary"><i class="fa fa-barcode"></i></button>
                                            <input type="text" name="expense_category_name" id="lims_expensecategorysearch" placeholder="Please type expense category and select..." class="form-control" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-12">
                                        <h5>{{trans('file.Order Table')}} *</h5>
                                        <div class="table-responsive mt-3">
                                            <table id="myTable" class="table table-hover expense-list">
                                                <thead>
                                                    <tr>
                                                        <th>{{trans('file.date')}}</th>
                                                        <th>{{trans('file.Expense Category')}}</th>
                                                        <th>{{trans('file.Warehouse')}}</th>
                                                        <th>{{trans('file.Amount')}}</th>
                                                        
                                                        <th>{{trans('file.Account')}}</th>
                                                        <th>{{trans('file.Note')}}</th>
                                                        <th><i class="dripicons-trash"></i></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary" id="submit-btn">{{trans('file.submit')}}</button>
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
@push('scripts')
<script type="text/javascript">

    $("ul#expense").siblings('a').attr('aria-expanded','true');
    $("ul#expense").addClass("show");
    $("ul#expense #exp-create-menu").addClass("active");

    var rowindex;
    var warehouse_list = <?php echo json_encode($lims_warehouse_list) ?>;
    var account_list = <?php echo json_encode($lims_account_list) ?>;
    var todayDate = <?php echo json_encode(date('d-m-Y')) ?>

    $('.selectpicker').selectpicker({
        style: 'btn-link',
    });

    <?php $expense_category_array = []; ?>
    var expense_categories = [
        @foreach($lims_expense_category_list as $expense_category)
            <?php
                $expense_category_array[] = htmlspecialchars($expense_category->id . '|' . $expense_category->name);
            ?>
        @endforeach
        <?php
            echo  '"'.implode('","', $expense_category_array).'"';
        ?>
    ];

    var lims_expensecategorysearch = $('#lims_expensecategorysearch');

    lims_expensecategorysearch.autocomplete({
    source: function(request, response) {
        var matcher = new RegExp(".?" + $.ui.autocomplete.escapeRegex(request.term), "i");
        response($.grep(expense_categories, function(item) {
            return matcher.test(item);
        }));
    },
    response: function(event, ui) {
        if (ui.content.length == 1) {
            var data = ui.content[0].value;
            $(this).autocomplete( "close" );
            addExpenseCategory(data);
        };
    },
    select: function(event, ui) {
        var data = ui.item.value;
        addExpenseCategory(data);
    }
 });

    $('body').on('focus',".date", function() {
        $(this).datepicker({
            format: "dd-mm-yyyy",
            startDate: "<?php echo date("d-m-Y")?>",
            autoclose: true,
            todayHighlight: true
        });
    });


    //Delete product
    $("table.expense-list tbody").on("click", ".ibtnDel", function(event) {
        $(this).closest("tr").remove();
    });

    function addExpenseCategory(data) {
        info = data.split('|');
        var newRow = $("<tr>");
        var cols = '';
        cols += '<td><input type="text" class="form-control date" name="created_at[]" value="'+todayDate+'" /></td>';
        cols += '<td><input type="hidden" name="expense_category_id[]" value="'+info[0]+'"/>'+info[1]+'</td>';
        var warehouse_dropdown = '<select name="warehouse_id[]" class="form-control product-id">';
        for(i = 0; i < warehouse_list.length; i++) {
            warehouse_dropdown += '<option value="'+warehouse_list[i]['id']+'">'+warehouse_list[i]['name']+'</option>';
        }
        warehouse_dropdown += '</select>';

        var account_dropdown = '<select name="account_id[]" class="form-control product-id">';
        for(i = 0; i < account_list.length; i++) {
            account_dropdown += '<option value="'+account_list[i]['id']+'">'+account_list[i]['name']+'</option>';
        }
        account_dropdown += '</select>';

        cols += '<td>'+warehouse_dropdown+'</td>';
        cols += '<td><input type="number" class="form-control" name="amount[]" required /></td>';
        cols += '<td>'+account_dropdown+'</td>';
        cols += '<td><input type="text" class="form-control" name="note[]" /></td>';
        cols += '<td><button type="button" title="Delete" class="ibtnDel btn btn-md btn-danger">X</button></td>';
        newRow.append(cols);
        $("table.expense-list tbody").prepend(newRow);
        $("#lims_expensecategorysearch").val('');
    }

    $(window).keydown(function(e){
        if (e.which == 13) {
            var $targ = $(e.target);
            if (!$targ.is("textarea") && !$targ.is(":button,:submit")) {
                var focusNext = false;
                $(this).find(":input:visible:not([disabled],[readonly]), a").each(function(){
                    if (this === e.target) {
                        focusNext = true;
                    }
                    else if (focusNext){
                        $(this).focus();
                        return false;
                    }
                });
                return false;
            }
        }
    });

    $('#expense-form').on('submit',function(e){
        var rownumber = $('table.expense-list tbody tr:last').index();
        if (rownumber < 0) {
            alert("Please insert product to order table!")
            e.preventDefault();
        }
    });
</script>

<script type="text/javascript" src="https://js.stripe.com/v3/"></script>
@endpush
